package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSvalbardJanMayen: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇯",
        description = "flag: Svalbard & Jan Mayen",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-svalbard-jan-mayen", "svalbard-jan-mayen-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.375f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Svalbard & Jan Mayen.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSvalbardJanMayen: Emoji get() = _FlagSvalbardJanMayen

/**
 * Alias to emoji [FlagSvalbardJanMayen] (Flags: country-flag: flag: Svalbard & Jan Mayen).
*/
public val Emoji.Companion.SvalbardJanMayenFlag: Emoji get() = _FlagSvalbardJanMayen
