package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllCountryFlag() {
    add(intArrayOf(0x1f1e6, 0x1f1e8), _FlagAscensionIsland)
    add(intArrayOf(0x1f1e6, 0x1f1e9), _FlagAndorra)
    add(intArrayOf(0x1f1e6, 0x1f1ea), _FlagUnitedArabEmirates)
    add(intArrayOf(0x1f1e6, 0x1f1eb), _FlagAfghanistan)
    add(intArrayOf(0x1f1e6, 0x1f1ec), _FlagAntiguaBarbuda)
    add(intArrayOf(0x1f1e6, 0x1f1ee), _FlagAnguilla)
    add(intArrayOf(0x1f1e6, 0x1f1f1), _FlagAlbania)
    add(intArrayOf(0x1f1e6, 0x1f1f2), _FlagArmenia)
    add(intArrayOf(0x1f1e6, 0x1f1f4), _FlagAngola)
    add(intArrayOf(0x1f1e6, 0x1f1f6), _FlagAntarctica)
    add(intArrayOf(0x1f1e6, 0x1f1f7), _FlagArgentina)
    add(intArrayOf(0x1f1e6, 0x1f1f8), _FlagAmericanSamoa)
    add(intArrayOf(0x1f1e6, 0x1f1f9), _FlagAustria)
    add(intArrayOf(0x1f1e6, 0x1f1fa), _FlagAustralia)
    add(intArrayOf(0x1f1e6, 0x1f1fc), _FlagAruba)
    add(intArrayOf(0x1f1e6, 0x1f1fd), _FlagALandIslands)
    add(intArrayOf(0x1f1e6, 0x1f1ff), _FlagAzerbaijan)
    add(intArrayOf(0x1f1e7, 0x1f1e6), _FlagBosniaHerzegovina)
    add(intArrayOf(0x1f1e7, 0x1f1e7), _FlagBarbados)
    add(intArrayOf(0x1f1e7, 0x1f1e9), _FlagBangladesh)
    add(intArrayOf(0x1f1e7, 0x1f1ea), _FlagBelgium)
    add(intArrayOf(0x1f1e7, 0x1f1eb), _FlagBurkinaFaso)
    add(intArrayOf(0x1f1e7, 0x1f1ec), _FlagBulgaria)
    add(intArrayOf(0x1f1e7, 0x1f1ed), _FlagBahrain)
    add(intArrayOf(0x1f1e7, 0x1f1ee), _FlagBurundi)
    add(intArrayOf(0x1f1e7, 0x1f1ef), _FlagBenin)
    add(intArrayOf(0x1f1e7, 0x1f1f1), _FlagStBartheLemy)
    add(intArrayOf(0x1f1e7, 0x1f1f2), _FlagBermuda)
    add(intArrayOf(0x1f1e7, 0x1f1f3), _FlagBrunei)
    add(intArrayOf(0x1f1e7, 0x1f1f4), _FlagBolivia)
    add(intArrayOf(0x1f1e7, 0x1f1f6), _FlagCaribbeanNetherlands)
    add(intArrayOf(0x1f1e7, 0x1f1f7), _FlagBrazil)
    add(intArrayOf(0x1f1e7, 0x1f1f8), _FlagBahamas)
    add(intArrayOf(0x1f1e7, 0x1f1f9), _FlagBhutan)
    add(intArrayOf(0x1f1e7, 0x1f1fb), _FlagBouvetIsland)
    add(intArrayOf(0x1f1e7, 0x1f1fc), _FlagBotswana)
    add(intArrayOf(0x1f1e7, 0x1f1fe), _FlagBelarus)
    add(intArrayOf(0x1f1e7, 0x1f1ff), _FlagBelize)
    add(intArrayOf(0x1f1e8, 0x1f1e6), _FlagCanada)
    add(intArrayOf(0x1f1e8, 0x1f1e8), _FlagCocosKeelingIslands)
    add(intArrayOf(0x1f1e8, 0x1f1e9), _FlagCongoKinshasa)
    add(intArrayOf(0x1f1e8, 0x1f1eb), _FlagCentralAfricanRepublic)
    add(intArrayOf(0x1f1e8, 0x1f1ec), _FlagCongoBrazzaville)
    add(intArrayOf(0x1f1e8, 0x1f1ed), _FlagSwitzerland)
    add(intArrayOf(0x1f1e8, 0x1f1ee), _FlagCoTeDivoire)
    add(intArrayOf(0x1f1e8, 0x1f1f0), _FlagCookIslands)
    add(intArrayOf(0x1f1e8, 0x1f1f1), _FlagChile)
    add(intArrayOf(0x1f1e8, 0x1f1f2), _FlagCameroon)
    add(intArrayOf(0x1f1e8, 0x1f1f3), _FlagChina)
    add(intArrayOf(0x1f1e8, 0x1f1f4), _FlagColombia)
    add(intArrayOf(0x1f1e8, 0x1f1f5), _FlagClippertonIsland)
    add(intArrayOf(0x1f1e8, 0x1f1f6), _FlagSark)
    add(intArrayOf(0x1f1e8, 0x1f1f7), _FlagCostaRica)
    add(intArrayOf(0x1f1e8, 0x1f1fa), _FlagCuba)
    add(intArrayOf(0x1f1e8, 0x1f1fb), _FlagCapeVerde)
    add(intArrayOf(0x1f1e8, 0x1f1fc), _FlagCuracAo)
    add(intArrayOf(0x1f1e8, 0x1f1fd), _FlagChristmasIsland)
    add(intArrayOf(0x1f1e8, 0x1f1fe), _FlagCyprus)
    add(intArrayOf(0x1f1e8, 0x1f1ff), _FlagCzechia)
    add(intArrayOf(0x1f1e9, 0x1f1ea), _FlagGermany)
    add(intArrayOf(0x1f1e9, 0x1f1ec), _FlagDiegoGarcia)
    add(intArrayOf(0x1f1e9, 0x1f1ef), _FlagDjibouti)
    add(intArrayOf(0x1f1e9, 0x1f1f0), _FlagDenmark)
    add(intArrayOf(0x1f1e9, 0x1f1f2), _FlagDominica)
    add(intArrayOf(0x1f1e9, 0x1f1f4), _FlagDominicanRepublic)
    add(intArrayOf(0x1f1e9, 0x1f1ff), _FlagAlgeria)
    add(intArrayOf(0x1f1ea, 0x1f1e6), _FlagCeutaMelilla)
    add(intArrayOf(0x1f1ea, 0x1f1e8), _FlagEcuador)
    add(intArrayOf(0x1f1ea, 0x1f1ea), _FlagEstonia)
    add(intArrayOf(0x1f1ea, 0x1f1ec), _FlagEgypt)
    add(intArrayOf(0x1f1ea, 0x1f1ed), _FlagWesternSahara)
    add(intArrayOf(0x1f1ea, 0x1f1f7), _FlagEritrea)
    add(intArrayOf(0x1f1ea, 0x1f1f8), _FlagSpain)
    add(intArrayOf(0x1f1ea, 0x1f1f9), _FlagEthiopia)
    add(intArrayOf(0x1f1ea, 0x1f1fa), _FlagEuropeanUnion)
    add(intArrayOf(0x1f1eb, 0x1f1ee), _FlagFinland)
    add(intArrayOf(0x1f1eb, 0x1f1ef), _FlagFiji)
    add(intArrayOf(0x1f1eb, 0x1f1f0), _FlagFalklandIslands)
    add(intArrayOf(0x1f1eb, 0x1f1f2), _FlagMicronesia)
    add(intArrayOf(0x1f1eb, 0x1f1f4), _FlagFaroeIslands)
    add(intArrayOf(0x1f1eb, 0x1f1f7), _FlagFrance)
    add(intArrayOf(0x1f1ec, 0x1f1e6), _FlagGabon)
    add(intArrayOf(0x1f1ec, 0x1f1e7), _FlagUnitedKingdom)
    add(intArrayOf(0x1f1ec, 0x1f1e9), _FlagGrenada)
    add(intArrayOf(0x1f1ec, 0x1f1ea), _FlagGeorgia)
    add(intArrayOf(0x1f1ec, 0x1f1eb), _FlagFrenchGuiana)
    add(intArrayOf(0x1f1ec, 0x1f1ec), _FlagGuernsey)
    add(intArrayOf(0x1f1ec, 0x1f1ed), _FlagGhana)
    add(intArrayOf(0x1f1ec, 0x1f1ee), _FlagGibraltar)
    add(intArrayOf(0x1f1ec, 0x1f1f1), _FlagGreenland)
    add(intArrayOf(0x1f1ec, 0x1f1f2), _FlagGambia)
    add(intArrayOf(0x1f1ec, 0x1f1f3), _FlagGuinea)
    add(intArrayOf(0x1f1ec, 0x1f1f5), _FlagGuadeloupe)
    add(intArrayOf(0x1f1ec, 0x1f1f6), _FlagEquatorialGuinea)
    add(intArrayOf(0x1f1ec, 0x1f1f7), _FlagGreece)
    add(intArrayOf(0x1f1ec, 0x1f1f8), _FlagSouthGeorgiaSouthSandwichIslands)
    add(intArrayOf(0x1f1ec, 0x1f1f9), _FlagGuatemala)
    add(intArrayOf(0x1f1ec, 0x1f1fa), _FlagGuam)
    add(intArrayOf(0x1f1ec, 0x1f1fc), _FlagGuineaBissau)
    add(intArrayOf(0x1f1ec, 0x1f1fe), _FlagGuyana)
    add(intArrayOf(0x1f1ed, 0x1f1f0), _FlagHongKongSarChina)
    add(intArrayOf(0x1f1ed, 0x1f1f2), _FlagHeardMcdonaldIslands)
    add(intArrayOf(0x1f1ed, 0x1f1f3), _FlagHonduras)
    add(intArrayOf(0x1f1ed, 0x1f1f7), _FlagCroatia)
    add(intArrayOf(0x1f1ed, 0x1f1f9), _FlagHaiti)
    add(intArrayOf(0x1f1ed, 0x1f1fa), _FlagHungary)
    add(intArrayOf(0x1f1ee, 0x1f1e8), _FlagCanaryIslands)
    add(intArrayOf(0x1f1ee, 0x1f1e9), _FlagIndonesia)
    add(intArrayOf(0x1f1ee, 0x1f1ea), _FlagIreland)
    add(intArrayOf(0x1f1ee, 0x1f1f1), _FlagIsrael)
    add(intArrayOf(0x1f1ee, 0x1f1f2), _FlagIsleOfMan)
    add(intArrayOf(0x1f1ee, 0x1f1f3), _FlagIndia)
    add(intArrayOf(0x1f1ee, 0x1f1f4), _FlagBritishIndianOceanTerritory)
    add(intArrayOf(0x1f1ee, 0x1f1f6), _FlagIraq)
    add(intArrayOf(0x1f1ee, 0x1f1f7), _FlagIran)
    add(intArrayOf(0x1f1ee, 0x1f1f8), _FlagIceland)
    add(intArrayOf(0x1f1ee, 0x1f1f9), _FlagItaly)
    add(intArrayOf(0x1f1ef, 0x1f1ea), _FlagJersey)
    add(intArrayOf(0x1f1ef, 0x1f1f2), _FlagJamaica)
    add(intArrayOf(0x1f1ef, 0x1f1f4), _FlagJordan)
    add(intArrayOf(0x1f1ef, 0x1f1f5), _FlagJapan)
    add(intArrayOf(0x1f1f0, 0x1f1ea), _FlagKenya)
    add(intArrayOf(0x1f1f0, 0x1f1ec), _FlagKyrgyzstan)
    add(intArrayOf(0x1f1f0, 0x1f1ed), _FlagCambodia)
    add(intArrayOf(0x1f1f0, 0x1f1ee), _FlagKiribati)
    add(intArrayOf(0x1f1f0, 0x1f1f2), _FlagComoros)
    add(intArrayOf(0x1f1f0, 0x1f1f3), _FlagStKittsNevis)
    add(intArrayOf(0x1f1f0, 0x1f1f5), _FlagNorthKorea)
    add(intArrayOf(0x1f1f0, 0x1f1f7), _FlagSouthKorea)
    add(intArrayOf(0x1f1f0, 0x1f1fc), _FlagKuwait)
    add(intArrayOf(0x1f1f0, 0x1f1fe), _FlagCaymanIslands)
    add(intArrayOf(0x1f1f0, 0x1f1ff), _FlagKazakhstan)
    add(intArrayOf(0x1f1f1, 0x1f1e6), _FlagLaos)
    add(intArrayOf(0x1f1f1, 0x1f1e7), _FlagLebanon)
    add(intArrayOf(0x1f1f1, 0x1f1e8), _FlagStLucia)
    add(intArrayOf(0x1f1f1, 0x1f1ee), _FlagLiechtenstein)
    add(intArrayOf(0x1f1f1, 0x1f1f0), _FlagSriLanka)
    add(intArrayOf(0x1f1f1, 0x1f1f7), _FlagLiberia)
    add(intArrayOf(0x1f1f1, 0x1f1f8), _FlagLesotho)
    add(intArrayOf(0x1f1f1, 0x1f1f9), _FlagLithuania)
    add(intArrayOf(0x1f1f1, 0x1f1fa), _FlagLuxembourg)
    add(intArrayOf(0x1f1f1, 0x1f1fb), _FlagLatvia)
    add(intArrayOf(0x1f1f1, 0x1f1fe), _FlagLibya)
    add(intArrayOf(0x1f1f2, 0x1f1e6), _FlagMorocco)
    add(intArrayOf(0x1f1f2, 0x1f1e8), _FlagMonaco)
    add(intArrayOf(0x1f1f2, 0x1f1e9), _FlagMoldova)
    add(intArrayOf(0x1f1f2, 0x1f1ea), _FlagMontenegro)
    add(intArrayOf(0x1f1f2, 0x1f1eb), _FlagStMartin)
    add(intArrayOf(0x1f1f2, 0x1f1ec), _FlagMadagascar)
    add(intArrayOf(0x1f1f2, 0x1f1ed), _FlagMarshallIslands)
    add(intArrayOf(0x1f1f2, 0x1f1f0), _FlagNorthMacedonia)
    add(intArrayOf(0x1f1f2, 0x1f1f1), _FlagMali)
    add(intArrayOf(0x1f1f2, 0x1f1f2), _FlagMyanmarBurma)
    add(intArrayOf(0x1f1f2, 0x1f1f3), _FlagMongolia)
    add(intArrayOf(0x1f1f2, 0x1f1f4), _FlagMacaoSarChina)
    add(intArrayOf(0x1f1f2, 0x1f1f5), _FlagNorthernMarianaIslands)
    add(intArrayOf(0x1f1f2, 0x1f1f6), _FlagMartinique)
    add(intArrayOf(0x1f1f2, 0x1f1f7), _FlagMauritania)
    add(intArrayOf(0x1f1f2, 0x1f1f8), _FlagMontserrat)
    add(intArrayOf(0x1f1f2, 0x1f1f9), _FlagMalta)
    add(intArrayOf(0x1f1f2, 0x1f1fa), _FlagMauritius)
    add(intArrayOf(0x1f1f2, 0x1f1fb), _FlagMaldives)
    add(intArrayOf(0x1f1f2, 0x1f1fc), _FlagMalawi)
    add(intArrayOf(0x1f1f2, 0x1f1fd), _FlagMexico)
    add(intArrayOf(0x1f1f2, 0x1f1fe), _FlagMalaysia)
    add(intArrayOf(0x1f1f2, 0x1f1ff), _FlagMozambique)
    add(intArrayOf(0x1f1f3, 0x1f1e6), _FlagNamibia)
    add(intArrayOf(0x1f1f3, 0x1f1e8), _FlagNewCaledonia)
    add(intArrayOf(0x1f1f3, 0x1f1ea), _FlagNiger)
    add(intArrayOf(0x1f1f3, 0x1f1eb), _FlagNorfolkIsland)
    add(intArrayOf(0x1f1f3, 0x1f1ec), _FlagNigeria)
    add(intArrayOf(0x1f1f3, 0x1f1ee), _FlagNicaragua)
    add(intArrayOf(0x1f1f3, 0x1f1f1), _FlagNetherlands)
    add(intArrayOf(0x1f1f3, 0x1f1f4), _FlagNorway)
    add(intArrayOf(0x1f1f3, 0x1f1f5), _FlagNepal)
    add(intArrayOf(0x1f1f3, 0x1f1f7), _FlagNauru)
    add(intArrayOf(0x1f1f3, 0x1f1fa), _FlagNiue)
    add(intArrayOf(0x1f1f3, 0x1f1ff), _FlagNewZealand)
    add(intArrayOf(0x1f1f4, 0x1f1f2), _FlagOman)
    add(intArrayOf(0x1f1f5, 0x1f1e6), _FlagPanama)
    add(intArrayOf(0x1f1f5, 0x1f1ea), _FlagPeru)
    add(intArrayOf(0x1f1f5, 0x1f1eb), _FlagFrenchPolynesia)
    add(intArrayOf(0x1f1f5, 0x1f1ec), _FlagPapuaNewGuinea)
    add(intArrayOf(0x1f1f5, 0x1f1ed), _FlagPhilippines)
    add(intArrayOf(0x1f1f5, 0x1f1f0), _FlagPakistan)
    add(intArrayOf(0x1f1f5, 0x1f1f1), _FlagPoland)
    add(intArrayOf(0x1f1f5, 0x1f1f2), _FlagStPierreMiquelon)
    add(intArrayOf(0x1f1f5, 0x1f1f3), _FlagPitcairnIslands)
    add(intArrayOf(0x1f1f5, 0x1f1f7), _FlagPuertoRico)
    add(intArrayOf(0x1f1f5, 0x1f1f8), _FlagPalestinianTerritories)
    add(intArrayOf(0x1f1f5, 0x1f1f9), _FlagPortugal)
    add(intArrayOf(0x1f1f5, 0x1f1fc), _FlagPalau)
    add(intArrayOf(0x1f1f5, 0x1f1fe), _FlagParaguay)
    add(intArrayOf(0x1f1f6, 0x1f1e6), _FlagQatar)
    add(intArrayOf(0x1f1f7, 0x1f1ea), _FlagReUnion)
    add(intArrayOf(0x1f1f7, 0x1f1f4), _FlagRomania)
    add(intArrayOf(0x1f1f7, 0x1f1f8), _FlagSerbia)
    add(intArrayOf(0x1f1f7, 0x1f1fa), _FlagRussia)
    add(intArrayOf(0x1f1f7, 0x1f1fc), _FlagRwanda)
    add(intArrayOf(0x1f1f8, 0x1f1e6), _FlagSaudiArabia)
    add(intArrayOf(0x1f1f8, 0x1f1e7), _FlagSolomonIslands)
    add(intArrayOf(0x1f1f8, 0x1f1e8), _FlagSeychelles)
    add(intArrayOf(0x1f1f8, 0x1f1e9), _FlagSudan)
    add(intArrayOf(0x1f1f8, 0x1f1ea), _FlagSweden)
    add(intArrayOf(0x1f1f8, 0x1f1ec), _FlagSingapore)
    add(intArrayOf(0x1f1f8, 0x1f1ed), _FlagStHelena)
    add(intArrayOf(0x1f1f8, 0x1f1ee), _FlagSlovenia)
    add(intArrayOf(0x1f1f8, 0x1f1ef), _FlagSvalbardJanMayen)
    add(intArrayOf(0x1f1f8, 0x1f1f0), _FlagSlovakia)
    add(intArrayOf(0x1f1f8, 0x1f1f1), _FlagSierraLeone)
    add(intArrayOf(0x1f1f8, 0x1f1f2), _FlagSanMarino)
    add(intArrayOf(0x1f1f8, 0x1f1f3), _FlagSenegal)
    add(intArrayOf(0x1f1f8, 0x1f1f4), _FlagSomalia)
    add(intArrayOf(0x1f1f8, 0x1f1f7), _FlagSuriname)
    add(intArrayOf(0x1f1f8, 0x1f1f8), _FlagSouthSudan)
    add(intArrayOf(0x1f1f8, 0x1f1f9), _FlagSaOTomePriNcipe)
    add(intArrayOf(0x1f1f8, 0x1f1fb), _FlagElSalvador)
    add(intArrayOf(0x1f1f8, 0x1f1fd), _FlagSintMaarten)
    add(intArrayOf(0x1f1f8, 0x1f1fe), _FlagSyria)
    add(intArrayOf(0x1f1f8, 0x1f1ff), _FlagEswatini)
    add(intArrayOf(0x1f1f9, 0x1f1e6), _FlagTristanDaCunha)
    add(intArrayOf(0x1f1f9, 0x1f1e8), _FlagTurksCaicosIslands)
    add(intArrayOf(0x1f1f9, 0x1f1e9), _FlagChad)
    add(intArrayOf(0x1f1f9, 0x1f1eb), _FlagFrenchSouthernTerritories)
    add(intArrayOf(0x1f1f9, 0x1f1ec), _FlagTogo)
    add(intArrayOf(0x1f1f9, 0x1f1ed), _FlagThailand)
    add(intArrayOf(0x1f1f9, 0x1f1ef), _FlagTajikistan)
    add(intArrayOf(0x1f1f9, 0x1f1f0), _FlagTokelau)
    add(intArrayOf(0x1f1f9, 0x1f1f1), _FlagTimorLeste)
    add(intArrayOf(0x1f1f9, 0x1f1f2), _FlagTurkmenistan)
    add(intArrayOf(0x1f1f9, 0x1f1f3), _FlagTunisia)
    add(intArrayOf(0x1f1f9, 0x1f1f4), _FlagTonga)
    add(intArrayOf(0x1f1f9, 0x1f1f7), _FlagTuRkiye)
    add(intArrayOf(0x1f1f9, 0x1f1f9), _FlagTrinidadTobago)
    add(intArrayOf(0x1f1f9, 0x1f1fb), _FlagTuvalu)
    add(intArrayOf(0x1f1f9, 0x1f1fc), _FlagTaiwan)
    add(intArrayOf(0x1f1f9, 0x1f1ff), _FlagTanzania)
    add(intArrayOf(0x1f1fa, 0x1f1e6), _FlagUkraine)
    add(intArrayOf(0x1f1fa, 0x1f1ec), _FlagUganda)
    add(intArrayOf(0x1f1fa, 0x1f1f2), _FlagUSOutlyingIslands)
    add(intArrayOf(0x1f1fa, 0x1f1f3), _FlagUnitedNations)
    add(intArrayOf(0x1f1fa, 0x1f1f8), _FlagUnitedStates)
    add(intArrayOf(0x1f1fa, 0x1f1fe), _FlagUruguay)
    add(intArrayOf(0x1f1fa, 0x1f1ff), _FlagUzbekistan)
    add(intArrayOf(0x1f1fb, 0x1f1e6), _FlagVaticanCity)
    add(intArrayOf(0x1f1fb, 0x1f1e8), _FlagStVincentGrenadines)
    add(intArrayOf(0x1f1fb, 0x1f1ea), _FlagVenezuela)
    add(intArrayOf(0x1f1fb, 0x1f1ec), _FlagBritishVirginIslands)
    add(intArrayOf(0x1f1fb, 0x1f1ee), _FlagUSVirginIslands)
    add(intArrayOf(0x1f1fb, 0x1f1f3), _FlagVietnam)
    add(intArrayOf(0x1f1fb, 0x1f1fa), _FlagVanuatu)
    add(intArrayOf(0x1f1fc, 0x1f1eb), _FlagWallisFutuna)
    add(intArrayOf(0x1f1fc, 0x1f1f8), _FlagSamoa)
    add(intArrayOf(0x1f1fd, 0x1f1f0), _FlagKosovo)
    add(intArrayOf(0x1f1fe, 0x1f1ea), _FlagYemen)
    add(intArrayOf(0x1f1fe, 0x1f1f9), _FlagMayotte)
    add(intArrayOf(0x1f1ff, 0x1f1e6), _FlagSouthAfrica)
    add(intArrayOf(0x1f1ff, 0x1f1f2), _FlagZambia)
    add(intArrayOf(0x1f1ff, 0x1f1fc), _FlagZimbabwe)
}

internal suspend fun SequenceScope<Emoji>.yieldAllCountryFlag() {
    yield(_FlagAscensionIsland)
    yield(_FlagAndorra)
    yield(_FlagUnitedArabEmirates)
    yield(_FlagAfghanistan)
    yield(_FlagAntiguaBarbuda)
    yield(_FlagAnguilla)
    yield(_FlagAlbania)
    yield(_FlagArmenia)
    yield(_FlagAngola)
    yield(_FlagAntarctica)
    yield(_FlagArgentina)
    yield(_FlagAmericanSamoa)
    yield(_FlagAustria)
    yield(_FlagAustralia)
    yield(_FlagAruba)
    yield(_FlagALandIslands)
    yield(_FlagAzerbaijan)
    yield(_FlagBosniaHerzegovina)
    yield(_FlagBarbados)
    yield(_FlagBangladesh)
    yield(_FlagBelgium)
    yield(_FlagBurkinaFaso)
    yield(_FlagBulgaria)
    yield(_FlagBahrain)
    yield(_FlagBurundi)
    yield(_FlagBenin)
    yield(_FlagStBartheLemy)
    yield(_FlagBermuda)
    yield(_FlagBrunei)
    yield(_FlagBolivia)
    yield(_FlagCaribbeanNetherlands)
    yield(_FlagBrazil)
    yield(_FlagBahamas)
    yield(_FlagBhutan)
    yield(_FlagBouvetIsland)
    yield(_FlagBotswana)
    yield(_FlagBelarus)
    yield(_FlagBelize)
    yield(_FlagCanada)
    yield(_FlagCocosKeelingIslands)
    yield(_FlagCongoKinshasa)
    yield(_FlagCentralAfricanRepublic)
    yield(_FlagCongoBrazzaville)
    yield(_FlagSwitzerland)
    yield(_FlagCoTeDivoire)
    yield(_FlagCookIslands)
    yield(_FlagChile)
    yield(_FlagCameroon)
    yield(_FlagChina)
    yield(_FlagColombia)
    yield(_FlagClippertonIsland)
    yield(_FlagSark)
    yield(_FlagCostaRica)
    yield(_FlagCuba)
    yield(_FlagCapeVerde)
    yield(_FlagCuracAo)
    yield(_FlagChristmasIsland)
    yield(_FlagCyprus)
    yield(_FlagCzechia)
    yield(_FlagGermany)
    yield(_FlagDiegoGarcia)
    yield(_FlagDjibouti)
    yield(_FlagDenmark)
    yield(_FlagDominica)
    yield(_FlagDominicanRepublic)
    yield(_FlagAlgeria)
    yield(_FlagCeutaMelilla)
    yield(_FlagEcuador)
    yield(_FlagEstonia)
    yield(_FlagEgypt)
    yield(_FlagWesternSahara)
    yield(_FlagEritrea)
    yield(_FlagSpain)
    yield(_FlagEthiopia)
    yield(_FlagEuropeanUnion)
    yield(_FlagFinland)
    yield(_FlagFiji)
    yield(_FlagFalklandIslands)
    yield(_FlagMicronesia)
    yield(_FlagFaroeIslands)
    yield(_FlagFrance)
    yield(_FlagGabon)
    yield(_FlagUnitedKingdom)
    yield(_FlagGrenada)
    yield(_FlagGeorgia)
    yield(_FlagFrenchGuiana)
    yield(_FlagGuernsey)
    yield(_FlagGhana)
    yield(_FlagGibraltar)
    yield(_FlagGreenland)
    yield(_FlagGambia)
    yield(_FlagGuinea)
    yield(_FlagGuadeloupe)
    yield(_FlagEquatorialGuinea)
    yield(_FlagGreece)
    yield(_FlagSouthGeorgiaSouthSandwichIslands)
    yield(_FlagGuatemala)
    yield(_FlagGuam)
    yield(_FlagGuineaBissau)
    yield(_FlagGuyana)
    yield(_FlagHongKongSarChina)
    yield(_FlagHeardMcdonaldIslands)
    yield(_FlagHonduras)
    yield(_FlagCroatia)
    yield(_FlagHaiti)
    yield(_FlagHungary)
    yield(_FlagCanaryIslands)
    yield(_FlagIndonesia)
    yield(_FlagIreland)
    yield(_FlagIsrael)
    yield(_FlagIsleOfMan)
    yield(_FlagIndia)
    yield(_FlagBritishIndianOceanTerritory)
    yield(_FlagIraq)
    yield(_FlagIran)
    yield(_FlagIceland)
    yield(_FlagItaly)
    yield(_FlagJersey)
    yield(_FlagJamaica)
    yield(_FlagJordan)
    yield(_FlagJapan)
    yield(_FlagKenya)
    yield(_FlagKyrgyzstan)
    yield(_FlagCambodia)
    yield(_FlagKiribati)
    yield(_FlagComoros)
    yield(_FlagStKittsNevis)
    yield(_FlagNorthKorea)
    yield(_FlagSouthKorea)
    yield(_FlagKuwait)
    yield(_FlagCaymanIslands)
    yield(_FlagKazakhstan)
    yield(_FlagLaos)
    yield(_FlagLebanon)
    yield(_FlagStLucia)
    yield(_FlagLiechtenstein)
    yield(_FlagSriLanka)
    yield(_FlagLiberia)
    yield(_FlagLesotho)
    yield(_FlagLithuania)
    yield(_FlagLuxembourg)
    yield(_FlagLatvia)
    yield(_FlagLibya)
    yield(_FlagMorocco)
    yield(_FlagMonaco)
    yield(_FlagMoldova)
    yield(_FlagMontenegro)
    yield(_FlagStMartin)
    yield(_FlagMadagascar)
    yield(_FlagMarshallIslands)
    yield(_FlagNorthMacedonia)
    yield(_FlagMali)
    yield(_FlagMyanmarBurma)
    yield(_FlagMongolia)
    yield(_FlagMacaoSarChina)
    yield(_FlagNorthernMarianaIslands)
    yield(_FlagMartinique)
    yield(_FlagMauritania)
    yield(_FlagMontserrat)
    yield(_FlagMalta)
    yield(_FlagMauritius)
    yield(_FlagMaldives)
    yield(_FlagMalawi)
    yield(_FlagMexico)
    yield(_FlagMalaysia)
    yield(_FlagMozambique)
    yield(_FlagNamibia)
    yield(_FlagNewCaledonia)
    yield(_FlagNiger)
    yield(_FlagNorfolkIsland)
    yield(_FlagNigeria)
    yield(_FlagNicaragua)
    yield(_FlagNetherlands)
    yield(_FlagNorway)
    yield(_FlagNepal)
    yield(_FlagNauru)
    yield(_FlagNiue)
    yield(_FlagNewZealand)
    yield(_FlagOman)
    yield(_FlagPanama)
    yield(_FlagPeru)
    yield(_FlagFrenchPolynesia)
    yield(_FlagPapuaNewGuinea)
    yield(_FlagPhilippines)
    yield(_FlagPakistan)
    yield(_FlagPoland)
    yield(_FlagStPierreMiquelon)
    yield(_FlagPitcairnIslands)
    yield(_FlagPuertoRico)
    yield(_FlagPalestinianTerritories)
    yield(_FlagPortugal)
    yield(_FlagPalau)
    yield(_FlagParaguay)
    yield(_FlagQatar)
    yield(_FlagReUnion)
    yield(_FlagRomania)
    yield(_FlagSerbia)
    yield(_FlagRussia)
    yield(_FlagRwanda)
    yield(_FlagSaudiArabia)
    yield(_FlagSolomonIslands)
    yield(_FlagSeychelles)
    yield(_FlagSudan)
    yield(_FlagSweden)
    yield(_FlagSingapore)
    yield(_FlagStHelena)
    yield(_FlagSlovenia)
    yield(_FlagSvalbardJanMayen)
    yield(_FlagSlovakia)
    yield(_FlagSierraLeone)
    yield(_FlagSanMarino)
    yield(_FlagSenegal)
    yield(_FlagSomalia)
    yield(_FlagSuriname)
    yield(_FlagSouthSudan)
    yield(_FlagSaOTomePriNcipe)
    yield(_FlagElSalvador)
    yield(_FlagSintMaarten)
    yield(_FlagSyria)
    yield(_FlagEswatini)
    yield(_FlagTristanDaCunha)
    yield(_FlagTurksCaicosIslands)
    yield(_FlagChad)
    yield(_FlagFrenchSouthernTerritories)
    yield(_FlagTogo)
    yield(_FlagThailand)
    yield(_FlagTajikistan)
    yield(_FlagTokelau)
    yield(_FlagTimorLeste)
    yield(_FlagTurkmenistan)
    yield(_FlagTunisia)
    yield(_FlagTonga)
    yield(_FlagTuRkiye)
    yield(_FlagTrinidadTobago)
    yield(_FlagTuvalu)
    yield(_FlagTaiwan)
    yield(_FlagTanzania)
    yield(_FlagUkraine)
    yield(_FlagUganda)
    yield(_FlagUSOutlyingIslands)
    yield(_FlagUnitedNations)
    yield(_FlagUnitedStates)
    yield(_FlagUruguay)
    yield(_FlagUzbekistan)
    yield(_FlagVaticanCity)
    yield(_FlagStVincentGrenadines)
    yield(_FlagVenezuela)
    yield(_FlagBritishVirginIslands)
    yield(_FlagUSVirginIslands)
    yield(_FlagVietnam)
    yield(_FlagVanuatu)
    yield(_FlagWallisFutuna)
    yield(_FlagSamoa)
    yield(_FlagKosovo)
    yield(_FlagYemen)
    yield(_FlagMayotte)
    yield(_FlagSouthAfrica)
    yield(_FlagZambia)
    yield(_FlagZimbabwe)
}

internal val countCountryFlag = 259

/**
 * All Emoji of the Flags: country-flag subgroup.
*/
public fun Emoji.Companion.sequenceCountryFlag(): Sequence<Emoji> =
    sequence { yieldAllCountryFlag() }

/**
 * All Emoji of the Flags: country-flag subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listCountryFlag(): List<Emoji> =
    ArrayList<Emoji>(countCountryFlag).also { list -> sequenceCountryFlag().forEach { list.add(it) } }

@Deprecated("Renamed listCountryFlag.", replaceWith = ReplaceWith("listCountryFlag()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allCountryFlag(): List<Emoji> =
    listCountryFlag()
