package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BeerMug: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍺",
        description = "beer mug",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("beer-mug", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: beer mug.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BeerMug: Emoji get() = _BeerMug
