package org.kodein.emoji.food_drink.food_vegetable

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RootVegetable: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫜",
        description = "root vegetable",
        unicodeVersion = UnicodeVersion(16, 0),
        aliases = listOf("root-vegetable", "beet", "turnip"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Food & Drink: food-vegetable: root vegetable.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RootVegetable: Emoji get() = _RootVegetable

/**
 * Alias to emoji [RootVegetable] (Food & Drink: food-vegetable: root vegetable).
*/
public val Emoji.Companion.Beet: Emoji get() = _RootVegetable

/**
 * Alias to emoji [RootVegetable] (Food & Drink: food-vegetable: root vegetable).
*/
public val Emoji.Companion.Turnip: Emoji get() = _RootVegetable
