package org.kodein.emoji.objects

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.objects.clothing.*
import org.kodein.emoji.objects.sound.*
import org.kodein.emoji.objects.music.*
import org.kodein.emoji.objects.musical_instrument.*
import org.kodein.emoji.objects.phone.*
import org.kodein.emoji.objects.computer.*
import org.kodein.emoji.objects.light_video.*
import org.kodein.emoji.objects.book_paper.*
import org.kodein.emoji.objects.money.*
import org.kodein.emoji.objects.mail.*
import org.kodein.emoji.objects.writing.*
import org.kodein.emoji.objects.office.*
import org.kodein.emoji.objects.lock.*
import org.kodein.emoji.objects.tool.*
import org.kodein.emoji.objects.science.*
import org.kodein.emoji.objects.medical.*
import org.kodein.emoji.objects.household.*
import org.kodein.emoji.objects.other_object.*


internal fun EmojiFinder.addAllObjects() {
    addAllClothing()
    addAllSound()
    addAllMusic()
    addAllMusicalInstrument()
    addAllPhone()
    addAllComputer()
    addAllLightVideo()
    addAllBookPaper()
    addAllMoney()
    addAllMail()
    addAllWriting()
    addAllOffice()
    addAllLock()
    addAllTool()
    addAllScience()
    addAllMedical()
    addAllHousehold()
    addAllOtherObject()
}

internal suspend fun SequenceScope<Emoji>.yieldAllObjects() {
    yieldAllClothing()
    yieldAllSound()
    yieldAllMusic()
    yieldAllMusicalInstrument()
    yieldAllPhone()
    yieldAllComputer()
    yieldAllLightVideo()
    yieldAllBookPaper()
    yieldAllMoney()
    yieldAllMail()
    yieldAllWriting()
    yieldAllOffice()
    yieldAllLock()
    yieldAllTool()
    yieldAllScience()
    yieldAllMedical()
    yieldAllHousehold()
    yieldAllOtherObject()
}

internal val countObjects = 266

/**
 * All Emoji of the Objects group.
*/
public fun Emoji.Companion.sequenceObjects(): Sequence<Emoji> =
    sequence { yieldAllObjects() }

/**
 * All Emoji of the Objects group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allObjects(): List<Emoji> =
    ArrayList<Emoji>(countObjects).also { list -> sequenceObjects().forEach { list.add(it) } }

internal fun allObjectsSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "clothing" to { Emoji.listClothing() },
        "sound" to { Emoji.listSound() },
        "music" to { Emoji.listMusic() },
        "musical_instrument" to { Emoji.listMusicalInstrument() },
        "phone" to { Emoji.listPhone() },
        "computer" to { Emoji.listComputer() },
        "light_video" to { Emoji.listLightVideo() },
        "book_paper" to { Emoji.listBookPaper() },
        "money" to { Emoji.listMoney() },
        "mail" to { Emoji.listMail() },
        "writing" to { Emoji.listWriting() },
        "office" to { Emoji.listOffice() },
        "lock" to { Emoji.listLock() },
        "tool" to { Emoji.listTool() },
        "science" to { Emoji.listScience() },
        "medical" to { Emoji.listMedical() },
        "household" to { Emoji.listHousehold() },
        "other_object" to { Emoji.listOtherObject() },
    )
