package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HighHeeledShoe: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👠",
        description = "high-heeled shoe",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("high-heeled-shoe", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: high-heeled shoe.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HighHeeledShoe: Emoji get() = _HighHeeledShoe
