package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SafetyVest: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦺",
        description = "safety vest",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("safety-vest", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: safety vest.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SafetyVest: Emoji get() = _SafetyVest
