package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Battery: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔋",
        description = "battery",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("battery", "battery-full"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: computer: battery.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Battery: Emoji get() = _Battery

/**
 * Alias to emoji [Battery] (Objects: computer: battery).
*/
public val Emoji.Companion.BatteryFull: Emoji get() = _Battery
