package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CameraWithFlash: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📸",
        description = "camera with flash",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("camera-with-flash", "camera-flash"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: light & video: camera with flash.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CameraWithFlash: Emoji get() = _CameraWithFlash

/**
 * Alias to emoji [CameraWithFlash] (Objects: light & video: camera with flash).
*/
public val Emoji.Companion.CameraFlash: Emoji get() = _CameraWithFlash
