package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Envelope: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✉️",
        description = "envelope",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("envelope", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: mail: envelope.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Envelope: Emoji get() = _Envelope
