package org.kodein.emoji.objects.medical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AdhesiveBandage: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩹",
        description = "adhesive bandage",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("adhesive-bandage", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: medical: adhesive bandage.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AdhesiveBandage: Emoji get() = _AdhesiveBandage
