package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TreasureChest: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪎",
        description = "treasure chest",
        unicodeVersion = UnicodeVersion(17, 0),
        aliases = listOf("treasure-chest", "treasure"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: money: treasure chest.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TreasureChest: Emoji get() = _TreasureChest

/**
 * Alias to emoji [TreasureChest] (Objects: money: treasure chest).
*/
public val Emoji.Companion.Treasure: Emoji get() = _TreasureChest
