package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMoney() {
    add(intArrayOf(0x1fa99), _Coin)
    add(intArrayOf(0x1f4b0), _MoneyBag)
    add(intArrayOf(0x1fa8e), _TreasureChest)
    add(intArrayOf(0x1f4b4), _YenBanknote)
    add(intArrayOf(0x1f4b5), _DollarBanknote)
    add(intArrayOf(0x1f4b6), _EuroBanknote)
    add(intArrayOf(0x1f4b7), _PoundBanknote)
    add(intArrayOf(0x1f4b8), _MoneyWithWings)
    add(intArrayOf(0x1f4b3), _CreditCard)
    add(intArrayOf(0x1f9fe), _Receipt)
    add(intArrayOf(0x1f4b9), _ChartIncreasingWithYen)
}

internal suspend fun SequenceScope<Emoji>.yieldAllMoney() {
    yield(_Coin)
    yield(_MoneyBag)
    yield(_TreasureChest)
    yield(_YenBanknote)
    yield(_DollarBanknote)
    yield(_EuroBanknote)
    yield(_PoundBanknote)
    yield(_MoneyWithWings)
    yield(_CreditCard)
    yield(_Receipt)
    yield(_ChartIncreasingWithYen)
}

internal val countMoney = 11

/**
 * All Emoji of the Objects: money subgroup.
*/
public fun Emoji.Companion.sequenceMoney(): Sequence<Emoji> =
    sequence { yieldAllMoney() }

/**
 * All Emoji of the Objects: money subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listMoney(): List<Emoji> =
    ArrayList<Emoji>(countMoney).also { list -> sequenceMoney().forEach { list.add(it) } }

@Deprecated("Renamed listMoney.", replaceWith = ReplaceWith("listMoney()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allMoney(): List<Emoji> =
    listMoney()
