package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BrokenChain: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛓️‍💥",
        description = "broken chain",
        unicodeVersion = UnicodeVersion(15, 1),
        aliases = listOf("broken-chain", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: tool: broken chain.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BrokenChain: Emoji get() = _BrokenChain
