package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Shovel: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪏",
        description = "shovel",
        unicodeVersion = UnicodeVersion(16, 0),
        aliases = listOf("shovel", "dig"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: tool: shovel.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Shovel: Emoji get() = _Shovel

/**
 * Alias to emoji [Shovel] (Objects: tool: shovel).
*/
public val Emoji.Companion.Dig: Emoji get() = _Shovel
