package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyManWomanBoy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👨‍👩‍👦",
        description = "family: man, woman, boy",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("family-man-woman-boy", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: family: family: man, woman, boy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyManWomanBoy: Emoji get() = _FamilyManWomanBoy
