package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _Kiss: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "💏",
        description = "kiss",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("kiss", "kiss-people"),
        emoticons = listOf("(-}{-)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "🧑‍❤‍💋‍🧑",
    zwjUnicodeVersion = UnicodeVersion(13, 1),
    sk21c = 2,
    sk22c = 10,
)

/**
 * Emoji People & Body: family: kiss.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Kiss: SkinTone2Emoji get() = _Kiss

/**
 * Alias to emoji [Kiss] (People & Body: family: kiss).
*/
public val Emoji.Companion.KissPeople: SkinTone2Emoji get() = _Kiss
