package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _KissWomanWoman: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "👩‍❤️‍💋‍👩",
        description = "kiss: woman, woman",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("kiss-woman-woman", "kiss-woman-and-woman"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk21c = 2,
    sk22c = 11,
)

/**
 * Emoji People & Body: family: kiss: woman, woman.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KissWomanWoman: SkinTone2Emoji get() = _KissWomanWoman

/**
 * Alias to emoji [KissWomanWoman] (People & Body: family: kiss: woman, woman).
*/
public val Emoji.Companion.KissWomanAndWoman: SkinTone2Emoji get() = _KissWomanWoman
