package org.kodein.emoji.people_body.hand_fingers_partial

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PinchingHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤏",
        description = "pinching hand",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("pinching-hand", "pinch"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-partial: pinching hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PinchingHand: SkinTone1Emoji get() = _PinchingHand

/**
 * Alias to emoji [PinchingHand] (People & Body: hand-fingers-partial: pinching hand).
*/
public val Emoji.Companion.Pinch: SkinTone1Emoji get() = _PinchingHand
