package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _BackhandIndexPointingDown: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👇",
        description = "backhand index pointing down",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("backhand-index-pointing-down", "point-down"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-single-finger: backhand index pointing down.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BackhandIndexPointingDown: SkinTone1Emoji get() = _BackhandIndexPointingDown

/**
 * Alias to emoji [BackhandIndexPointingDown] (People & Body: hand-single-finger: backhand index pointing down).
*/
public val Emoji.Companion.PointDown: SkinTone1Emoji get() = _BackhandIndexPointingDown
