package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _MenWithBunnyEars: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "👯‍♂️",
        description = "men with bunny ears",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("men-with-bunny-ears", "bunny-ears-men"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "👨‍🐰‍👨",
    zwjUnicodeVersion = UnicodeVersion(17, 0),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: person-activity: men with bunny ears.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MenWithBunnyEars: SkinTone2Emoji get() = _MenWithBunnyEars

/**
 * Alias to emoji [MenWithBunnyEars] (People & Body: person-activity: men with bunny ears).
*/
public val Emoji.Companion.BunnyEarsMen: SkinTone2Emoji get() = _MenWithBunnyEars
