package org.kodein.emoji.people_body.person_fantasy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HairyCreature: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫈",
        description = "hairy creature",
        unicodeVersion = UnicodeVersion(17, 0),
        aliases = listOf("hairy-creature", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: person-fantasy: hairy creature.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HairyCreature: Emoji get() = _HairyCreature
