package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonRaisingHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙋",
        description = "person raising hand",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-raising-hand", "raising-hand"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person raising hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonRaisingHand: SkinTone1Emoji get() = _PersonRaisingHand

/**
 * Alias to emoji [PersonRaisingHand] (People & Body: person-gesture: person raising hand).
*/
public val Emoji.Companion.RaisingHand: SkinTone1Emoji get() = _PersonRaisingHand
