package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyAdultChild: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🧒",
        description = "family: adult, child",
        unicodeVersion = UnicodeVersion(15, 1),
        aliases = listOf("family-adult-child", "family-2"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: person-symbol: family: adult, child.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyAdultChild: Emoji get() = _FamilyAdultChild

/**
 * Alias to emoji [FamilyAdultChild] (People & Body: person-symbol: family: adult, child).
*/
public val Emoji.Companion.Family2: Emoji get() = _FamilyAdultChild
