package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FightCloud: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫯",
        description = "fight cloud",
        unicodeVersion = UnicodeVersion(17, 0),
        aliases = listOf("fight-cloud", "fight"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: fight cloud.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FightCloud: Emoji get() = _FightCloud

/**
 * Alias to emoji [FightCloud] (Smileys & Emotion: emotion: fight cloud).
*/
public val Emoji.Companion.Fight: Emoji get() = _FightCloud
