package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceScreamingInFear: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😱",
        description = "face screaming in fear",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-screaming-in-fear", "screaming"),
        emoticons = listOf("@0@"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: face screaming in fear.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceScreamingInFear: Emoji get() = _FaceScreamingInFear

/**
 * Alias to emoji [FaceScreamingInFear] (Smileys & Emotion: face-concerned: face screaming in fear).
*/
public val Emoji.Companion.Screaming: Emoji get() = _FaceScreamingInFear
