package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithBagsUnderEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫩",
        description = "face with bags under eyes",
        unicodeVersion = UnicodeVersion(16, 0),
        aliases = listOf("face-with-bags-under-eyes", "tired", "bags-under-eyes"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-sleepy: face with bags under eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithBagsUnderEyes: Emoji get() = _FaceWithBagsUnderEyes

/**
 * Alias to emoji [FaceWithBagsUnderEyes] (Smileys & Emotion: face-sleepy: face with bags under eyes).
*/
public val Emoji.Companion.Tired: Emoji get() = _FaceWithBagsUnderEyes

/**
 * Alias to emoji [FaceWithBagsUnderEyes] (Smileys & Emotion: face-sleepy: face with bags under eyes).
*/
public val Emoji.Companion.BagsUnderEyes: Emoji get() = _FaceWithBagsUnderEyes
