package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithTearsOfJoy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😂",
        description = "face with tears of joy",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-with-tears-of-joy", "joy"),
        emoticons = listOf(">w<"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: face with tears of joy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithTearsOfJoy: Emoji get() = _FaceWithTearsOfJoy

/**
 * Alias to emoji [FaceWithTearsOfJoy] (Smileys & Emotion: face-smiling: face with tears of joy).
*/
public val Emoji.Companion.Joy: Emoji get() = _FaceWithTearsOfJoy
