package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UpButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆙",
        description = "UP! button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("up-button", "up-"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: UP! button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UpButton: Emoji get() = _UpButton

/**
 * Alias to emoji [UpButton] (Symbols: alphanum: UP! button).
*/
public val Emoji.Companion.Up: Emoji get() = _UpButton
