package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DownLeftArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "↙️",
        description = "down-left arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("down-left-arrow", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: down-left arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DownLeftArrow: Emoji get() = _DownLeftArrow
