package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FastUpButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏫",
        description = "fast up button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fast-up-button", "fast-up", "double-triangle-up"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: fast up button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FastUpButton: Emoji get() = _FastUpButton

/**
 * Alias to emoji [FastUpButton] (Symbols: av-symbol: fast up button).
*/
public val Emoji.Companion.FastUp: Emoji get() = _FastUpButton

/**
 * Alias to emoji [FastUpButton] (Symbols: av-symbol: fast up button).
*/
public val Emoji.Companion.DoubleTriangleUp: Emoji get() = _FastUpButton
