package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StopButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏹️",
        description = "stop button",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("stop-button", "square-button"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: stop button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StopButton: Emoji get() = _StopButton

/**
 * Alias to emoji [StopButton] (Symbols: av-symbol: stop button).
*/
public val Emoji.Companion.SquareButton: Emoji get() = _StopButton
