package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟥",
        description = "red square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("red-square", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: red square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedSquare: Emoji get() = _RedSquare
