package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Multiply: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✖️",
        description = "multiply",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("multiply", "multiplication-x"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: math: multiply.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Multiply: Emoji get() = _Multiply

/**
 * Alias to emoji [Multiply] (Symbols: math: multiply).
*/
public val Emoji.Companion.MultiplicationX: Emoji get() = _Multiply
