package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedExclamationMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❗",
        description = "red exclamation mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-exclamation-mark", "exclamation", "exclamation-mark"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: punctuation: red exclamation mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedExclamationMark: Emoji get() = _RedExclamationMark

/**
 * Alias to emoji [RedExclamationMark] (Symbols: punctuation: red exclamation mark).
*/
public val Emoji.Companion.Exclamation: Emoji get() = _RedExclamationMark

/**
 * Alias to emoji [RedExclamationMark] (Symbols: punctuation: red exclamation mark).
*/
public val Emoji.Companion.ExclamationMark: Emoji get() = _RedExclamationMark
