package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapanesePostOffice: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏣",
        description = "Japanese post office",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-post-office", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-building: Japanese post office.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapanesePostOffice: Emoji get() = _JapanesePostOffice
