package org.kodein.emoji.travel_places.place_geographic

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Landslide: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛘",
        description = "landslide",
        unicodeVersion = UnicodeVersion(17, 0),
        aliases = listOf("landslide", "debris"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-geographic: landslide.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Landslide: Emoji get() = _Landslide

/**
 * Alias to emoji [Landslide] (Travel & Places: place-geographic: landslide).
*/
public val Emoji.Companion.Debris: Emoji get() = _Landslide
