package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AlarmClock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏰",
        description = "alarm clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("alarm-clock", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: time: alarm clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AlarmClock: Emoji get() = _AlarmClock
