package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBotswana: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇼",
        description = "flag: Botswana",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-botswana", "botswana-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Botswana.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBotswana: Emoji get() = _FlagBotswana

/**
 * Alias to emoji [FlagBotswana] (Flags: country-flag: flag: Botswana).
*/
public val Emoji.Companion.BotswanaFlag: Emoji get() = _FlagBotswana
