package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMayotte: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇾🇹",
        description = "flag: Mayotte",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mayotte", "mayotte-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mayotte.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMayotte: Emoji get() = _FlagMayotte

/**
 * Alias to emoji [FlagMayotte] (Flags: country-flag: flag: Mayotte).
*/
public val Emoji.Companion.MayotteFlag: Emoji get() = _FlagMayotte
