package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTimorLeste: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇱",
        description = "flag: Timor-Leste",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-timor-leste", "timor-leste-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Timor-Leste.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTimorLeste: Emoji get() = _FlagTimorLeste

/**
 * Alias to emoji [FlagTimorLeste] (Flags: country-flag: flag: Timor-Leste).
*/
public val Emoji.Companion.TimorLesteFlag: Emoji get() = _FlagTimorLeste
