package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏴",
        description = "black flag",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("black-flag", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: flag: black flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackFlag: Emoji get() = _BlackFlag
