package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HairPick: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪮",
        description = "hair pick",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("hair-pick", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: hair pick.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HairPick: Emoji get() = _HairPick
