package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CreditCard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💳",
        description = "credit card",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("credit-card", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: money: credit card.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CreditCard: Emoji get() = _CreditCard
