package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMoney() {
    add(intArrayOf(0x1fa99), _Coin)
    add(intArrayOf(0x1f4b8), _MoneyWithWings)
    add(intArrayOf(0x1f4b5), _DollarBanknote)
    add(intArrayOf(0x1f4b4), _YenBanknote)
    add(intArrayOf(0x1f4b6), _EuroBanknote)
    add(intArrayOf(0x1f4b7), _PoundBanknote)
    add(intArrayOf(0x1f4b3), _CreditCard)
    add(intArrayOf(0x1f4b0), _MoneyBag)
    add(intArrayOf(0x1f9fe), _Receipt)
    add(intArrayOf(0x1f4b9), _ChartIncreasingWithYen)
}

internal fun MutableList<Emoji>.addAllMoney() {
    add(_Coin)
    add(_MoneyWithWings)
    add(_DollarBanknote)
    add(_YenBanknote)
    add(_EuroBanknote)
    add(_PoundBanknote)
    add(_CreditCard)
    add(_MoneyBag)
    add(_Receipt)
    add(_ChartIncreasingWithYen)
}

/**
 * All Emoji of the Objects: money subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allMoney(): List<Emoji> =
    ArrayList<Emoji>(10).apply { addAllMoney() }
