package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DowncastFaceWithSweat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😓",
        description = "downcast face with sweat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("downcast-face-with-sweat", "sweat", "downcast"),
        emoticons = listOf("(0へ0)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: downcast face with sweat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DowncastFaceWithSweat: Emoji get() = _DowncastFaceWithSweat

/**
 * Alias to emoji [DowncastFaceWithSweat] (Smileys & Emotion: face-concerned: downcast face with sweat).
*/
public val Emoji.Companion.Sweat: Emoji get() = _DowncastFaceWithSweat

/**
 * Alias to emoji [DowncastFaceWithSweat] (Smileys & Emotion: face-concerned: downcast face with sweat).
*/
public val Emoji.Companion.Downcast: Emoji get() = _DowncastFaceWithSweat
