package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagHaiti: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇭🇹",
        description = "flag: Haiti",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-haiti", "haiti-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Haiti.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagHaiti: Emoji get() = _FlagHaiti

/**
 * Alias to emoji [FlagHaiti] (Flags: country-flag: flag: Haiti).
*/
public val Emoji.Companion.HaitiFlag: Emoji get() = _FlagHaiti
