package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RainbowFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏳️‍🌈",
        description = "rainbow flag",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("rainbow-flag", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: flag: rainbow flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RainbowFlag: Emoji get() = _RainbowFlag
