package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMail() {
    add(intArrayOf(0x1f4e6), _Package)
    add(intArrayOf(0x1f4eb), _ClosedMailboxWithRaisedFlag)
    add(intArrayOf(0x1f4ea), _ClosedMailboxWithLoweredFlag)
    add(intArrayOf(0x1f4ec), _OpenMailboxWithRaisedFlag)
    add(intArrayOf(0x1f4ed), _OpenMailboxWithLoweredFlag)
    add(intArrayOf(0x1f4ee), _Postbox)
    add(intArrayOf(0x2709, 0xfe0f), _Envelope)
    add(intArrayOf(0x2709), _Envelope)
    add(intArrayOf(0x1f4e7), _EMail)
    add(intArrayOf(0x1f4e9), _EnvelopeWithArrow)
    add(intArrayOf(0x1f4e8), _IncomingEnvelope)
    add(intArrayOf(0x1f4e4), _OutboxTray)
    add(intArrayOf(0x1f4e5), _InboxTray)
    add(intArrayOf(0x1f5f3, 0xfe0f), _BallotBoxWithBallot)
    add(intArrayOf(0x1f5f3), _BallotBoxWithBallot)
}

internal fun MutableList<Emoji>.addAllMail() {
    add(_Package)
    add(_ClosedMailboxWithRaisedFlag)
    add(_ClosedMailboxWithLoweredFlag)
    add(_OpenMailboxWithRaisedFlag)
    add(_OpenMailboxWithLoweredFlag)
    add(_Postbox)
    add(_Envelope)
    add(_EMail)
    add(_EnvelopeWithArrow)
    add(_IncomingEnvelope)
    add(_OutboxTray)
    add(_InboxTray)
    add(_BallotBoxWithBallot)
}

/**
 * All Emoji of the Objects: mail subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allMail(): List<Emoji> =
    ArrayList<Emoji>(13).apply { addAllMail() }
