package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Clipboard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📋",
        description = "clipboard",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("clipboard", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: clipboard.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Clipboard: Emoji get() = _Clipboard
